/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.rules;

import com.google.gson.JsonElement;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mcjty.incontrol.InControl;
import mcjty.incontrol.compat.ModRuleCompatibilityLayer;
import mcjty.incontrol.data.PhaseTools;
import mcjty.incontrol.rules.support.GenericRuleEvaluator;
import mcjty.incontrol.rules.support.RuleKeys;
import mcjty.tools.rules.CommonRuleEvaluator;
import mcjty.tools.rules.IEventQuery;
import mcjty.tools.rules.IModRuleCompatibilityLayer;
import mcjty.tools.rules.RuleBase;
import mcjty.tools.typed.Attribute;
import mcjty.tools.typed.AttributeMap;
import mcjty.tools.typed.GenericAttributeMapFactory;
import mcjty.tools.varia.Tools;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;

public class LootRule
extends RuleBase<RuleBase.EventGetter> {
    public static final IEventQuery<LivingDropsEvent> EVENT_QUERY = new IEventQuery<LivingDropsEvent>(){

        public World getWorld(LivingDropsEvent o) {
            return o.getEntity().func_130014_f_();
        }

        @Override
        public BlockPos getPos(LivingDropsEvent o) {
            return o.getEntity().func_233580_cy_();
        }

        @Override
        public BlockPos getValidBlockPos(LivingDropsEvent o) {
            return o.getEntity().func_233580_cy_().func_177977_b();
        }

        @Override
        public int getY(LivingDropsEvent o) {
            return o.getEntity().func_233580_cy_().func_177956_o();
        }

        @Override
        public Entity getEntity(LivingDropsEvent o) {
            return o.getEntity();
        }

        @Override
        public DamageSource getSource(LivingDropsEvent o) {
            return o.getSource();
        }

        @Override
        public Entity getAttacker(LivingDropsEvent o) {
            return o.getSource().func_76346_g();
        }

        @Override
        public PlayerEntity getPlayer(LivingDropsEvent o) {
            Entity entity = o.getSource().func_76346_g();
            return entity instanceof PlayerEntity ? (PlayerEntity)entity : null;
        }

        @Override
        public ItemStack getItem(LivingDropsEvent o) {
            return ItemStack.field_190927_a;
        }
    };
    private static final GenericAttributeMapFactory FACTORY = new GenericAttributeMapFactory();
    private static Random rnd = new Random();
    private final GenericRuleEvaluator ruleEvaluator;
    private final Set<String> phases;
    private List<Predicate<ItemStack>> toRemoveItems = new ArrayList<Predicate<ItemStack>>();
    private List<Pair<ItemStack, Function<Integer, Integer>>> toAddItems = new ArrayList<Pair<ItemStack, Function<Integer, Integer>>>();
    private boolean removeAll = false;

    private LootRule(AttributeMap map, Set<String> phases) {
        super(InControl.setup.getLogger());
        this.phases = phases;
        this.ruleEvaluator = new GenericRuleEvaluator(map);
        this.addActions(map, new ModRuleCompatibilityLayer());
    }

    public Set<String> getPhases() {
        return this.phases;
    }

    public static LootRule parse(JsonElement element) {
        if (element == null) {
            return null;
        }
        AttributeMap map = FACTORY.parse(element);
        return new LootRule(map, PhaseTools.getPhases(element));
    }

    @Override
    protected void addActions(AttributeMap map, IModRuleCompatibilityLayer layer) {
        super.addActions(map, layer);
        if (map.has(RuleKeys.ACTION_ITEM)) {
            this.addItem(map);
        }
        if (map.has(RuleKeys.ACTION_REMOVE)) {
            this.removeItem(map);
        }
        if (map.has(RuleKeys.ACTION_REMOVEALL)) {
            this.removeAll = map.get(RuleKeys.ACTION_REMOVEALL);
        }
    }

    public List<Predicate<ItemStack>> getToRemoveItems() {
        return this.toRemoveItems;
    }

    public boolean isRemoveAll() {
        return this.removeAll;
    }

    public List<Pair<ItemStack, Function<Integer, Integer>>> getToAddItems() {
        return this.toAddItems;
    }

    private Function<Integer, Integer> getCountFunction(@Nullable String itemcount) {
        if (itemcount == null) {
            return looting -> 1;
        }
        String[] loottable = StringUtils.split((String)itemcount, (char)'/');
        int[] min = new int[loottable.length];
        int[] max = new int[loottable.length];
        for (int i = 0; i < loottable.length; ++i) {
            String[] minmax = StringUtils.split((String)loottable[i], (char)'-');
            if (minmax.length == 1) {
                try {
                    min[i] = max[i] = Integer.parseInt(minmax[0]);
                }
                catch (NumberFormatException e) {
                    InControl.setup.getLogger().log(Level.ERROR, "Bad amount specified in loot rule: " + minmax);
                    max[i] = 1;
                    min[i] = 1;
                }
                continue;
            }
            if (minmax.length == 2) {
                try {
                    min[i] = Integer.parseInt(minmax[0]);
                    max[i] = Integer.parseInt(minmax[1]);
                }
                catch (NumberFormatException e) {
                    InControl.setup.getLogger().log(Level.ERROR, "Bad amounts specified in loot rule: " + minmax);
                    max[i] = 1;
                    min[i] = 1;
                }
                continue;
            }
            InControl.setup.getLogger().log(Level.ERROR, "Bad amount range specified in loot rule: " + minmax);
            max[i] = 1;
            min[i] = 1;
        }
        if (loottable.length == 1) {
            if (min[0] == max[0]) {
                return looting -> min[0];
            }
            return looting -> rnd.nextInt(max[0] - min[0] + 1) + min[0];
        }
        return looting -> {
            if (looting >= min.length) {
                return rnd.nextInt(max[min.length - 1] - min[min.length - 1] + 1) + min[min.length - 1];
            }
            if (looting >= 0) {
                return rnd.nextInt(max[looting] - min[looting] + 1) + min[looting];
            }
            return rnd.nextInt(max[0] - min[0] + 1) + min[0];
        };
    }

    private List<Pair<ItemStack, Function<Integer, Integer>>> getItems(List<String> itemNames, @Nullable String nbtJson, @Nullable String itemcount) {
        Function<Integer, Integer> countFunction = this.getCountFunction(itemcount);
        ArrayList<Pair<ItemStack, Function<Integer, Integer>>> items = new ArrayList<Pair<ItemStack, Function<Integer, Integer>>>();
        for (String name : itemNames) {
            ItemStack stack = Tools.parseStack(name, InControl.setup.getLogger());
            if (stack.func_190926_b()) {
                InControl.setup.getLogger().log(Level.ERROR, "Unknown item '" + name + "'!");
                continue;
            }
            if (nbtJson != null) {
                try {
                    stack.func_77982_d(JsonToNBT.func_180713_a((String)nbtJson));
                }
                catch (CommandSyntaxException e) {
                    InControl.setup.getLogger().log(Level.ERROR, "Bad nbt for '" + name + "'!");
                }
            }
            items.add((Pair<ItemStack, Function<Integer, Integer>>)Pair.of((Object)stack, countFunction));
        }
        return items;
    }

    private void addItem(AttributeMap map) {
        String nbt = map.get(RuleKeys.ACTION_ITEMNBT);
        String itemcount = map.get(RuleKeys.ACTION_ITEMCOUNT);
        this.toAddItems.addAll(this.getItems(map.getList(RuleKeys.ACTION_ITEM), nbt, itemcount));
    }

    private void removeItem(AttributeMap map) {
        this.toRemoveItems.addAll(CommonRuleEvaluator.getItems(map.getList(RuleKeys.ACTION_REMOVE), this.logger));
    }

    public boolean match(LivingDropsEvent event) {
        return this.ruleEvaluator.match(event, EVENT_QUERY);
    }

    static {
        FACTORY.attribute(Attribute.create(RuleKeys.MINTIME)).attribute(Attribute.create(RuleKeys.MAXTIME)).attribute(Attribute.create(RuleKeys.MINLIGHT)).attribute(Attribute.create(RuleKeys.MAXLIGHT)).attribute(Attribute.create(RuleKeys.MINHEIGHT)).attribute(Attribute.create(RuleKeys.MAXHEIGHT)).attribute(Attribute.create(RuleKeys.MINDIFFICULTY)).attribute(Attribute.create(RuleKeys.MAXDIFFICULTY)).attribute(Attribute.create(RuleKeys.MINSPAWNDIST)).attribute(Attribute.create(RuleKeys.MAXSPAWNDIST)).attribute(Attribute.create(RuleKeys.RANDOM)).attribute(Attribute.create(RuleKeys.INBUILDING)).attribute(Attribute.create(RuleKeys.INCITY)).attribute(Attribute.create(RuleKeys.GAMESTAGE)).attribute(Attribute.create(RuleKeys.WINTER)).attribute(Attribute.create(RuleKeys.SUMMER)).attribute(Attribute.create(RuleKeys.SPRING)).attribute(Attribute.create(RuleKeys.AUTUMN)).attribute(Attribute.create(RuleKeys.INSTREET)).attribute(Attribute.create(RuleKeys.INSPHERE)).attribute(Attribute.create(RuleKeys.PASSIVE)).attribute(Attribute.create(RuleKeys.HOSTILE)).attribute(Attribute.create(RuleKeys.SEESKY)).attribute(Attribute.create(RuleKeys.WEATHER)).attribute(Attribute.createMulti(RuleKeys.CATEGORY)).attribute(Attribute.create(RuleKeys.DIFFICULTY)).attribute(Attribute.create(RuleKeys.STRUCTURE)).attribute(Attribute.create(RuleKeys.PLAYER)).attribute(Attribute.create(RuleKeys.REALPLAYER)).attribute(Attribute.create(RuleKeys.FAKEPLAYER)).attribute(Attribute.create(RuleKeys.PROJECTILE)).attribute(Attribute.create(RuleKeys.EXPLOSION)).attribute(Attribute.create(RuleKeys.FIRE)).attribute(Attribute.create(RuleKeys.MAGIC)).attribute(Attribute.createMulti(RuleKeys.MOB)).attribute(Attribute.createMulti(RuleKeys.MOD)).attribute(Attribute.createMulti(RuleKeys.BLOCK)).attribute(Attribute.create(RuleKeys.BLOCKOFFSET)).attribute(Attribute.createMulti(RuleKeys.BIOME)).attribute(Attribute.createMulti(RuleKeys.BIOMETYPE)).attribute(Attribute.createMulti(RuleKeys.DIMENSION)).attribute(Attribute.createMulti(RuleKeys.DIMENSION_MOD)).attribute(Attribute.createMulti(RuleKeys.SOURCE)).attribute(Attribute.createMulti(RuleKeys.HELMET)).attribute(Attribute.createMulti(RuleKeys.CHESTPLATE)).attribute(Attribute.createMulti(RuleKeys.LEGGINGS)).attribute(Attribute.createMulti(RuleKeys.BOOTS)).attribute(Attribute.createMulti(RuleKeys.AMULET)).attribute(Attribute.createMulti(RuleKeys.RING)).attribute(Attribute.createMulti(RuleKeys.BELT)).attribute(Attribute.createMulti(RuleKeys.TRINKET)).attribute(Attribute.createMulti(RuleKeys.HEAD)).attribute(Attribute.createMulti(RuleKeys.BODY)).attribute(Attribute.createMulti(RuleKeys.CHARM)).attribute(Attribute.create(RuleKeys.STATE)).attribute(Attribute.create(RuleKeys.PSTATE)).attribute(Attribute.createMulti(RuleKeys.HELDITEM)).attribute(Attribute.createMulti(RuleKeys.PLAYER_HELDITEM)).attribute(Attribute.createMulti(RuleKeys.OFFHANDITEM)).attribute(Attribute.createMulti(RuleKeys.BOTHHANDSITEM)).attribute(Attribute.create(RuleKeys.ACTION_ITEMNBT)).attribute(Attribute.create(RuleKeys.ACTION_ITEMCOUNT)).attribute(Attribute.createMulti(RuleKeys.ACTION_ITEM)).attribute(Attribute.createMulti(RuleKeys.ACTION_REMOVE)).attribute(Attribute.create(RuleKeys.ACTION_REMOVEALL));
    }
}

